/* ***************************************************** **
   ch05_functions_defined_within_sql.sql
   
   Skrypt dla książki Praktyczna nauka SQL dla Oracle, Helion (2022),
   napisanej przez Kima Berga Hansena, https://www.kibeha.dk
   Używasz na własną odpowiedzialność.
   *****************************************************
   
   Rozdział 5.
   Funkcje zdefiniowane w języku SQL
   
   Skrypt przeznaczony do wykonania w schemacie PRACTICAL
** ***************************************************** */

/* -----------------------------------------------------
   Konfiguracja formatowania sqlcl
   ----------------------------------------------------- */

set pagesize 80
set linesize 80
set sqlformat ansiconsole

/* -----------------------------------------------------
   Przykładowe fragmenty kodu do rozdziału 5.
   ----------------------------------------------------- */

-- Listing 5.1. Dotyczące alkoholu dane dla piwa w grupie Stout

select
   p.id as p_id
 , p.name
 , pa.sales_volume as vol
 , pa.abv
from products p
join product_alcohol pa
   on pa.product_id = p.id
where p.group_id = 142
order by p.id;

-- Listing 5.2. Obliczanie stężenia alkoholu we krwi dla kobiet i mężczyzn

select
   p.id as p_id
 , p.name
 , pa.sales_volume as vol
 , pa.abv
 , round(
      100 * (pa.sales_volume * pa.abv / 100 * 0.789)
       / (80 * 1000 * 0.68)
    , 3
   ) bac_m
 , round(
      100 * (pa.sales_volume * pa.abv / 100 * 0.789)
       / (60 * 1000 * 0.55)
    , 3
   ) bac_f
from products p
join product_alcohol pa
   on pa.product_id = p.id
where p.group_id = 142
order by p.id;

-- Listing 5.4. Pobieranie wartości stężenia alkoholu we krwi dla kobiety i mężczyzny

select
   p.id as p_id
 , p.name
 , pa.sales_volume as vol
 , pa.abv
 , formulas.bac(pa.sales_volume, pa.abv, 80, 'M') bac_m
 , formulas.bac(pa.sales_volume, pa.abv, 60, 'F') bac_f
from products p
join product_alcohol pa
   on pa.product_id = p.id
where p.group_id = 142
order by p.id;

-- Listing 5.5. Obliczanie stężenia alkoholu we krwi za pomocą klauzuli with 

with
   function bac (
      p_volume in number
    , p_abv    in number
    , p_weight in number
    , p_gender in varchar2
   ) return number deterministic
   is
   begin
      return round(
         100 * (p_volume * p_abv / 100 * 0.789)
          / (p_weight * 1000 * case p_gender
                                  when 'M' then 0.68
                                  when 'F' then 0.55
                               end)
       , 3
      );
   end;
select
   p.id as p_id
 , p.name
 , pa.sales_volume as vol
 , pa.abv
 , bac(pa.sales_volume, pa.abv, 80, 'M') bac_m
 , bac(pa.sales_volume, pa.abv, 60, 'F') bac_f
from products p
join product_alcohol pa
   on pa.product_id = p.id
where p.group_id = 142
order by p.id
/

-- Listing 5.6. Przykład zdefiniowania wielu funkcji w klauzuli with

with
   function gram_alcohol (
      p_volume in number
    , p_abv    in number
   ) return number deterministic
   is
   begin
      return p_volume * p_abv / 100 * 0.789;
   end;
   function gram_body_fluid (
      p_weight in number
    , p_gender in varchar2
   ) return number deterministic
   is
   begin
      return p_weight * 1000 * case p_gender
                                  when 'M' then 0.68
                                  when 'F' then 0.55
                               end;
   end;
   function bac (
      p_volume in number
    , p_abv    in number
    , p_weight in number
    , p_gender in varchar2
   ) return number deterministic
   is
   begin
      return round(
         100 * gram_alcohol(p_volume, p_abv)
          / gram_body_fluid(p_weight, p_gender)
       , 3
      );
   end;
select
   p.id as p_id
 , p.name
 , pa.sales_volume as vol
 , pa.abv
 , bac(pa.sales_volume, pa.abv, 80, 'M') bac_m
 , bac(pa.sales_volume, pa.abv, 60, 'F') bac_f
from products p
join product_alcohol pa
   on pa.product_id = p.id
where p.group_id = 142
order by p.id
/

-- Listing 5.8. Pobieranie za pomocą widoku danych dotyczących stężenia alkoholu we krwi

select
   p.id as p_id
 , p.name
 , pab.sales_volume as vol
 , pab.abv
 , pab.bac_m
 , pab.bac_f
from products p
join product_alcohol_bac pab
   on pab.product_id = p.id
where p.group_id = 142
order by p.id;

/* ***************************************************** */
